/**
** Pase de fotos con efectos 
** Version V0.0. Junio 2013
** Version V0.1. Julio 2013. Puede aplicar transiciones en Crossfade existentes.                                                 
** Autor : A. Merino                                                          **
** Mlaga -Espaa-  Junio 2.013                                               **
** Realizado por nij para videoedicion.org                                    **
**                                                                            **
** Descripcion: Crea un pase de fotos aplicando zoom, movimiento y trasiciones**
**      Se puede configurar la forma de aplicar los efectos.                  **
**      Se puede seleccionar si aplicar o no Reduicir prpadeo.               **
**      Se puede seleccionar si aplicar o no Coincidir con Aspecto de salida. **
**/

import System.Windows.Forms;
import ScriptPortal.Vegas;
import ScriptPortal.Vegas.Script;

var NombrePGM = "Pase de fotos con efectos.js " ;
var VersionPGM = "V0.1 " ;
var TituloPGM = "-Aplica transiciones, zoom y movimiento aleatoriamente- " ;
var AutorPGM = "Nij para www.videoedicion.org";
var FechaPGM = "Malaga. Junio 2013";
var OriginalRulerFormat = Vegas.Project.Ruler.Format;
Vegas.Project.Ruler.Format = RulerFormat.AbsoluteFrames;
var zero : int = 0;
var numTransicion;
var TiempoKey2 =500;
var AplicarSoloFade  = false;
var AplicarAleatorio  = false; 
var TiempoTransicion =1;
var PorcentajeZoom = 80;
var AplicarReduceParpadeo = true;
var AplicarFormatoDeSalida = false;
var documento = new LeerDocumento();
documento.ListaTransicionesEN.Items.Add("  Transiciones Automaticas")
documento.ListaTransicionesEN.Items.Add("  Transiciones Fundido")
var totalTrans = Vegas.Transitions.Count;
var TransicionesVegas= new Enumerator(Vegas.Transitions);
while (!TransicionesVegas.atEnd()) 
{
  var TransicionVegas = TransicionesVegas.item();
  if (!TransicionVegas.IsContainer )  
  {	

     documento.ListaTransicionesEN.Items.Add(TransicionVegas.Name);
  }		
  TransicionesVegas.moveNext();
}

try {
 documento.ListaTransicionesEN.SelectedIndex = 0
 var documentoResult = documento.ShowDialog();
 if(System.Windows.Forms.DialogResult.OK == documentoResult)
 {
  var IndiceTransicion = int(documento.ListaTransicionesEN.SelectedIndex);
	if (IndiceTransicion == 0) 	AplicarAleatorio = true; 
  if (IndiceTransicion == 1)  AplicarSoloFade = true;
	var plugIn;
	if(IndiceTransicion > 1) plugIn = Vegas.Transitions.GetChild(int(IndiceTransicion -1)); 
  documento.TiempoTransicionEN.Text = documento.TiempoTransicionEN.Text.replace(",",".");   
	TiempoTransicion = new Timecode(int(Math.abs(double(documento.TiempoTransicionEN.Text)*1000))); 
  var InicioOffset = TiempoTransicion;
  TiempoKey2 = new Timecode(int(Math.abs(double(documento.TiempoTransicionEN.Text)*1000/2))); 
	PorcentajeZoom = int(Math.abs(documento.PorcentajeZoomEN.Text));
  AplicarFormatoDeSalida = boolean(documento.AplicarFormatoDeSalidaEN.Checked);
  AplicarReduceParpadeo =  boolean(documento.AplicarReduceParpadeoEN.Checked);
  if (AplicarFormatoDeSalida) 
  { 
     AjustarFormatoDeSalida ();
     Vegas.UpdateUI();
  }  
	var NumeroPistas = new Enumerator(Vegas.Project.Tracks);
	var Efecto;
 	while (!NumeroPistas.atEnd())
  {
	 var Pista = NumeroPistas.item();
   var NumeroEventos = new Enumerator(Pista.Events);
 		while (!NumeroEventos.atEnd())
    {
		 var Evento = NumeroEventos.item();
     if (AplicarReduceParpadeo) 
     { 
        Evento.ReduceInterlace = true;
     }       
     
     if (PorcentajeZoom  != 100 ) 
     {
      var TiempoIniciocode = new Timecode(Evento.Start);
			var TiempoFinalcode = new Timecode(Evento.Length);
      var KeyframeDos  = new Timecode(Evento.Length - TiempoKey2);           
 			var iniMotionKeyFrame = Evento.VideoMotion.Keyframes[0];
			var finMotionKeyFrame = new VideoMotionKeyframe(KeyframeDos);
      var movimiento = int (double (Math.random() * 10));

      if (movimiento < 2 )    // zoom out
      {
 			 var EscalaA = new VideoMotionVertex(float(1), float(1));
    	 Evento.VideoMotion.Keyframes.Add(finMotionKeyFrame);
       finMotionKeyFrame.ScaleBy(EscalaA);
       var EscalaB = new VideoMotionVertex(float(PorcentajeZoom / 100.0), float(PorcentajeZoom / 100.0)); 
       iniMotionKeyFrame.ScaleBy(EscalaB);            
     }
     else if (movimiento < 4 )  // zoom in
     {
       var EscalaB = new VideoMotionVertex(float(1), float(1));
       iniMotionKeyFrame.ScaleBy(EscalaB);
 		   var EscalaA = new VideoMotionVertex(float(PorcentajeZoom / 100.0), float(PorcentajeZoom / 100.0)); 
       Evento.VideoMotion.Keyframes.Add(finMotionKeyFrame);
       finMotionKeyFrame.ScaleBy(EscalaA);      
     }
      else if (movimiento < 7 )   // Movimiento diagonal
      {
     	 var EscalaA = new VideoMotionVertex(float(PorcentajeZoom / 100.0), float(PorcentajeZoom / 100.0));
     	 iniMotionKeyFrame.ScaleBy(EscalaA);
			 var Offset = new VideoMotionVertex(-iniMotionKeyFrame.TopLeft.X, -iniMotionKeyFrame.TopLeft.Y);    
			 if (Math.random() > 0.5) {Offset.X = Offset.X * -1.0};
			 if (Math.random() > 0.5) {Offset.Y = Offset.Y * -1.0}; 
 			 iniMotionKeyFrame.MoveBy(Offset);
			 Offset.X = Offset.X *(-2.0);
			 Offset.Y = Offset.Y*(-2.0);
			 Evento.VideoMotion.Keyframes.Add(finMotionKeyFrame);
       finMotionKeyFrame.MoveBy(Offset);	
      }
      else 
      {   
       if (Math.random() > 0.9)  // Movimiento  horizontal
       {   
        var EscalaA = new VideoMotionVertex(float(PorcentajeZoom / 100.0), float(PorcentajeZoom / 100.0));
     	  iniMotionKeyFrame.ScaleBy(EscalaA);
        var Offset = new VideoMotionVertex(-iniMotionKeyFrame.TopLeft.X, 1);        
			  if (Math.random() > 0.5) {Offset.X = Offset.X * -1.0};
 			  iniMotionKeyFrame.MoveBy(Offset);    
			  Offset.X = Offset.X *(-2.0);
			  Evento.VideoMotion.Keyframes.Add(finMotionKeyFrame);
        finMotionKeyFrame.MoveBy(Offset);	
       
       }
       else                         // Movimiento vertical    
       {   
        var EscalaA = new VideoMotionVertex(float(PorcentajeZoom / 100.0), float(PorcentajeZoom / 100.0));
     	  iniMotionKeyFrame.ScaleBy(EscalaA);
			  var Offset = new VideoMotionVertex(1, -iniMotionKeyFrame.TopLeft.Y);    
			  if (Math.random() > 0.5) {Offset.Y = Offset.Y * -1.0}; 
 			  iniMotionKeyFrame.MoveBy(Offset);
			  Offset.Y = Offset.Y*(-2.0);
			  Evento.VideoMotion.Keyframes.Add(finMotionKeyFrame);
        finMotionKeyFrame.MoveBy(Offset);	
       }
      }
     }
		 Evento.FadeIn.Curve = CurveType.Slow
		 if(AplicarAleatorio)
     {
      var NumTransicion = false;
       while (!NumTransicion) 
       {           
			  numTransicion = int(Math.random() * (totalTrans - 1) + 1);
			  plugIn = Vegas.Transitions.GetChild(numTransicion); 
        if (!plugIn.IsContainer )
        {
       	 NumTransicion = true;
        } 
        if (plugIn.Name =="Flash VEGAS")
        {
         NumTransicion = false;
        }                           
       }
      }  
			var TiempoInicio = new Timecode(Evento.Start);
			var LongitudEvento = new Timecode(Evento.Length);
 			var offset = new Timecode(InicioOffset);
			TiempoInicio  = TiempoInicio - offset;
			Evento.AdjustStartLength(TiempoInicio,LongitudEvento,true);
      Vegas.UpdateUI();
			if(Evento.MediaType == MediaType.Video && !AplicarSoloFade)
			{
       var PreseTransicion = plugIn.Presets;
       var PreseAplicar = PreseTransicion[int(Math.random() * PreseTransicion.Count)];
			 Efecto = new Effect(plugIn);
			 Evento.FadeIn.Transition = Efecto;
       Efecto.Preset = PreseAplicar;    
		  }
			NumeroEventos.moveNext();
			InicioOffset = InicioOffset + TiempoTransicion;
		}
		InicioOffset = TiempoTransicion;
		NumeroPistas.moveNext();
  }
  Vegas.Project.Ruler.Format = OriginalRulerFormat;
  Vegas.UpdateUI();
  print ("!Hecho!",NombrePGM + VersionPGM + " de " + AutorPGM);
 }
}
catch (e) 
{
	MessageBox.Show(e + " Error al Aplicar " + numTransicion + " " + plugIn.Name);
}

Vegas.Project.Ruler.Format = OriginalRulerFormat;

//Funciones 
function AjustarFormatoDeSalida ()
{
  var AnchoProyecto  = Vegas.Project.Video.Width;
  var AltoProyecto = Vegas.Project.Video.Height;
  var AspectoPixel = Vegas.Project.Video.PixelAspectRatio;
  var AspectoProyecto = AspectoPixel * AnchoProyecto / AltoProyecto;
  var PistasProyecto = Vegas.Project.Tracks.Count;
  var xx;
  for (xx = zero; xx < PistasProyecto; xx ++)
  { 
    var PistaActual   = Vegas.Project.Tracks[xx];
    if (! PistaActual.IsVideo())
       continue;   
    var EventosPista : Enumerator = new Enumerator(PistaActual.Events);            
    while ( ! EventosPista.atEnd() ) 
    {
      var EventoActual : TrackEvent = EventosPista.item();                                                                                   
      var MediaActual = ObtenerMedio (EventoActual);                            
        if (MediaActual)
        {                            
           var CorrienteVideo = VideoStream (MediaActual);                  
           var MediaPixelRatio = CorrienteVideo.PixelAspectRatio;
           var EventoVideo        = VideoEvent(EventosPista.item());    
           var KeyFrames         = EventoVideo.VideoMotion.Keyframes;  
           var ContadorKeyFrames = KeyFrames.Count;
           var yy;  
           for (yy = zero; yy < ContadorKeyFrames; yy ++)
           {
               AplicarAspectoDeSalida (KeyFrames[yy], MediaPixelRatio, AspectoProyecto);                                                                     
           }
        }
      EventosPista.moveNext();
    }
  }
}
function ObtenerMedio (EventoActual : TrackEvent)
{
        if (EventoActual.ActiveTake.IsValid())
        {        
           var media = Vegas.Project.MediaPool.Find (EventoActual.ActiveTake.MediaPath);      
           if (null !== media)
           {      
             var MediaActual = media.Streams.GetItemByMediaType (MediaType.Video, EventoActual.ActiveTake.StreamIndex);         
             return MediaActual;
           }
        }
}

function AplicarAspectoDeSalida (keyframe : VideoMotionKeyframe, MediaPixelRatio : double, aspectoSalida : double)
{
    var Rotacion = keyframe.Rotation;    
    keyframe.RotateBy (-Rotacion);
    var ancho = Math.abs(keyframe.TopRight.X - keyframe.TopLeft.X);
    var alto  = Math.abs(keyframe.BottomLeft.Y - keyframe.TopLeft.Y);
    var aspecto = MediaPixelRatio * ancho / alto;
    var centroY = keyframe.Center.Y;
    var centroX = keyframe.Center.X;                
    var factor;        
    var recorte = new VideoMotionBounds(keyframe.TopLeft, keyframe.TopRight, keyframe.BottomRight, keyframe.BottomLeft);
    if (aspecto < aspectoSalida)
    {        
       factor = aspecto / aspectoSalida;                                    
       recorte.TopLeft.Y     = (recorte.TopLeft.Y     - centroY) * factor + centroY;
       recorte.TopRight.Y    = (recorte.TopRight.Y    - centroY) * factor + centroY;
       recorte.BottomLeft.Y  = (recorte.BottomLeft.Y  - centroY) * factor + centroY;
       recorte.BottomRight.Y = (recorte.BottomRight.Y - centroY) * factor + centroY;            
    }
    else
    {                          
       factor = aspectoSalida / aspecto;                                  
       recorte.TopLeft.X     = (recorte.TopLeft.X     - centroX) * factor + centroX;
       recorte.TopRight.X    = (recorte.TopRight.X    - centroX) * factor + centroX;
       recorte.BottomLeft.X  = (recorte.BottomLeft.X  - centroX) * factor + centroX;
       recorte.BottomRight.X = (recorte.BottomRight.X - centroX) * factor + centroX;
    }
    keyframe.Bounds = recorte;   
    keyframe.RotateBy (Rotacion);
}
function print (m,c) 
{
   MessageBox.Show(m,c);
}

//Formulario
class LeerDocumento extends Form 
{
 var PorcentajeZoomEN;
 var TiempoTransicionEN;
 var AplicarFormatoDeSalidaEN; 
 var AplicarReduceParpadeoEN;
 var ListaTransicionesEN;
 var CajaTexto = new GroupBox();  
 var CajaAviso = new GroupBox(); 
 var Fille = "";
 var Fil1EN = "";

 function LeerDocumento() 
 {
   this.Text = NombrePGM + TituloPGM;
   this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
   this.MaximizeBox = false;
   this.StartPosition = FormStartPosition.CenterScreen;
   this.Width = 650;
   this.Height = 450;
   var AnchoBoton = 80;
   var AltoBoton = 24;
   var BotonTop = 140;
   TiempoTransicionEN = VariableForm("Tiempo Transicion (seg.)", 20, 20, 170, 20, TiempoTransicion.ToString());
   PorcentajeZoomEN = VariableForm("   Porcentaje ZOOM", 45, 40, 140,20 ,PorcentajeZoom.ToString());
   AplicarReduceParpadeoEN = IncluirOpcion("Aplicar Reducir Parpadeo  ", 20, 70, AplicarReduceParpadeo);  
   AplicarFormatoDeSalidaEN = IncluirOpcion("Ajustar a formato de salida", 20, 90, AplicarFormatoDeSalida);   
   ListaTransicionesEN = ListaForm(360,80,20);  

   var BotonAceptar = new Button();
     BotonAceptar.Text = "Aceptar";
     BotonAceptar.Left = this.Left + 60;
     BotonAceptar.Top = BotonTop;
     BotonAceptar.Width = AnchoBoton;
     BotonAceptar.Height = AltoBoton;
     BotonAceptar.DialogResult = System.Windows.Forms.DialogResult.OK;
     AcceptButton = BotonAceptar;
     Controls.Add(BotonAceptar);
   var BotonAnular = new Button();
     BotonAnular.Text = "Anular";
     BotonAnular.Left = (BotonAceptar.Right + 100);
     BotonAnular.Top = BotonTop;
     BotonAnular.Width = AnchoBoton;
     BotonAnular.Height = AltoBoton;
     BotonAnular.DialogResult = System.Windows.Forms.DialogResult.Cancel;
     CancelButton = BotonAnular;
     Controls.Add(BotonAnular); 
     
      CajaTexto.Top = 180;
      CajaTexto.Left = 4;
      CajaTexto.Width = 350;
      CajaTexto.Height = 120; 
      Controls.Add(CajaTexto);
      Fille = TextoenCaja("Tiempo Transicion con valor 0, solo  aplica transiciones donde exista zona de Crossfade.", 4, 10, 340 ,30);  
      Fille = TextoenCaja("Porcentaje ZOOM con valor 100 no aplica efecto de zoom ni movimiento.", 4, 40, 340 ,30);
      Fille = TextoenCaja("Porcentaje ZOOM con valor distinto de 100 aplica efectos de zoom o movimiento de forma aleatoria. Mas cercano a 100, menor velocidad y menor recorte de imagen por los bordes.",4,70,340,40);  
      CajaAviso.Top = 310;
      CajaAviso.Left = 4;
      CajaAviso.Width = 350;
      CajaAviso.Height = 60;
      CajaAviso.Text = "AVISO";      
      CajaAviso.ForeColor = System.Drawing.Color.Red; 
      Controls.Add(CajaAviso);      
    var textoAviso = new Label();
      textoAviso.AutoSize = false;
      textoAviso.Text = "Debe estar activado el boton Crossfade Automatico (encima del Timeline), para poder generar el espacio de la transicion.";
      textoAviso.Left = 4;
      textoAviso.Top = 20;
      textoAviso.Width = 340;
      textoAviso.Height = 30;
      textoAviso.ForeColor = System.Drawing.Color.Blue;      
      CajaAviso.Controls.Add(textoAviso);
 var tituloAl = this.Height - this.ClientSize.Height;
 this.Height = tituloAl + CajaAviso.Bottom + 30; 
 
   var firma = new Label();
     firma.AutoSize = true;
     firma.Text = "por " + AutorPGM + "          "+ FechaPGM + "          " + VersionPGM;
     firma.Left = 10;
     firma.Top = this.Bottom - 50;
     firma.Width = 150;
     Controls.Add(firma);
 }

 function VariableForm(NombreEtiqueta, izquierda, altura, ancho, alto, valor) 
 {
   var etiquetaDoc = new Label();
     etiquetaDoc.AutoSize = true;
     etiquetaDoc.Text = NombreEtiqueta + ":";
     etiquetaDoc.Left = izquierda;
     etiquetaDoc.Top = altura + 4;
     etiquetaDoc.Width = ancho;
     Controls.Add(etiquetaDoc);
   var textoDoc = new TextBox();
     textoDoc.Multiline = false;
     textoDoc.Left = etiquetaDoc.Right;
     textoDoc.Top = altura;
     textoDoc.Width = ancho - (etiquetaDoc.Width);
     textoDoc.Text = valor;
     Controls.Add(textoDoc);
     return textoDoc;
 }

 function ListaForm(izquierda,ancho,alto) 
 {
   var ListaTransiciones = new ComboBox();
     ListaTransiciones.AutoSize = false;
     ListaTransiciones.DropDownWidth = ancho;
     ListaTransiciones.DropDownHeight = 480;
     ListaTransiciones.Location = new System.Drawing.Point(izquierda, alto);
     ListaTransiciones.Size = new System.Drawing.Size(200, 21);
     ListaTransiciones.TabIndex = 9;
     Controls.Add(ListaTransiciones);
 		 return ListaTransiciones;
 }
     function IncluirOpcion(etiqueta, izquierda, altura, checOnOf) {
        var etiquetar = new Label();
        etiquetar.AutoSize = true;
        etiquetar.Text = etiqueta;
        etiquetar.Left = izquierda;
        etiquetar.Top = altura + 4;
        Controls.Add(etiquetar);
        var ChecENTRADA = new CheckBox();
        ChecENTRADA.Left = etiquetar.Right;
        ChecENTRADA.Width = 36;
        ChecENTRADA.Top = altura;
        ChecENTRADA.Checked = checOnOf ;
        Controls.Add(ChecENTRADA);
        return ChecENTRADA;
     }

 function  TextoenCaja(textoe, izquierda, arriba, ancho, alto) 
 {
    var texto = new Label();
      texto.AutoSize = false;
      texto.Text = textoe;
      texto.Left = izquierda;
      texto.Top = arriba;
      texto.Width = ancho;
      texto.Height = alto;
      CajaTexto.Controls.Add(texto);
 }  
}

